<?php

class StockholmCoreElementorCenteredPortfolioCarousel extends \Elementor\Widget_Base{
	public function get_name() {
		return 'qode_centered_portfolio_carousel';
	}
	
	public function get_title() {
		return esc_html__('Centered Portfolio Carousel', 'stockholm-core');
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-centered-portfolio-carousel';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function register_controls(){
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'image_size',
			[
				'label' => esc_html__( "Image size", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''              => esc_html__( 'Default', 'stockholm-core' ),
					'full'          => esc_html__( 'Original Size', 'stockholm-core' ),
					'landscape'     => esc_html__( 'Landscape', 'stockholm-core' ),
					'portrait'      => esc_html__( 'Portrait', 'stockholm-core' )
				],
				'default' => ''
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( "Show Project Title", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''              => esc_html__( 'No ( Default )', 'stockholm-core' ),
					'yes'              => esc_html__( 'Yes', 'stockholm-core' )
				],
				'default' => ''
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Project Title Tag", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag(false ),
				'default' => 'h4',
                'condition' => [
                    'show_title' => 'yes'
                ]
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'query',
			[
				'label' => esc_html__( 'Build Query', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'number',
			[
				'label' => esc_html__('Number', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of portfolios on page (Leave empty for all)', 'stockholm-core' )
			]
		);
		
		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( "Order By", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'date'       => esc_html__( 'Date', 'stockholm-core' ),
					'title'      => esc_html__( 'Title', 'stockholm-core' )
				],
				'default' => 'date'
			]
		);
		
		$this->add_control(
			'order',
			[
				'label' => esc_html__( "Order", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_query_order_array(),
				'default' => ''
			]
		);
		
		$this->add_control(
			'category',
			[
				'label' => esc_html__( "Category", 'stockholm-core' ),
				"description" => esc_html__( "Category Slug (leave empty for all)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'selected_projects',
			[
				'label' => esc_html__( "Selected Posts", 'stockholm-core' ),
				"description" => esc_html__( "Selected Portfolios (leave empty for all, delimit by comma)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		
		$query_args            = $this->createQueryArgs( $params );
		$blog_query            = new \WP_Query( $query_args );
		$params['blog_query']  = $blog_query;
		$params['posts_shown'] = 1;
		$params['holder_data'] = $this->getHolderData( $params );
		$params['thumb_size']  = $this->getImageSize( $params );
		
		echo stockholm_qode_get_shortcode_template_part( 'templates/centered-portfolio-carousel-template', 'centered-portfolio-carousel', '', $params );
	}
	
	private function createQueryArgs( $params ) {
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => 'portfolio_page',
			'orderby'        => $params['order_by'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number']
		);
		
		if ( $params['category'] !== '' ) {
			$args['portfolio_category'] = $params['category'];
		}
		
		if ( $params['selected_projects'] !== '' ) {
			$args['post__in'] = explode( ",", $params['selected_projects'] );
		}
		
		return $args;
	}
	
	private function getHolderData( $params ) {
		$data                        = array();
		$data['data-enable-center']  = 'yes';
		$data['data-slider-padding'] = 'yes';
		$data['data-slider-margin']  = '38';
		
		if ( $params['posts_shown'] != '' ) {
			$data['data-number-of-items'] = $params['posts_shown'];
		}
		
		return $data;
	}
	
	private function getImageSize( $params ) {
		
		switch ( $params['image_size'] ) {
			case 'landscape':
				$thumb_size = 'portfolio-landscape';
				break;
			case 'portrait':
				$thumb_size = 'portfolio-portrait';
				break;
			default:
				$thumb_size = 'full';
				break;
		}
		
		return $thumb_size;
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorCenteredPortfolioCarousel() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCenteredPortfolioCarousel() );
}