<?php

if(function_exists("is_woocommerce")) {

    class StockholmCoreElementorProductCategoriesShowcase extends \Elementor\Widget_Base
    {
        public function get_name()
        {
            return 'qode_product_categories_showcase';
        }

        public function get_title()
        {
            return esc_html__("Product Category Showcase", 'stockholm-core');
        }

        public function get_icon()
        {
            return 'stockholm-elementor-custom-icon stockholm-elementor-product-categories-showcase';
        }

        public function get_categories()
        {
            return ['select'];
        }

        protected function register_controls()
        {

            $this->start_controls_section(
                'general',
                [
                    'label' => esc_html__('General', 'stockholm-core'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );
	
	        $this->add_control(
		        'cat_slug',
		        [
			        'label' => esc_html__("Category Slug", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::TEXT
		        ]
	        );
	
	        $this->add_control(
		        'product_id',
		        [
			        'label' => esc_html__("Product ID", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::TEXT
		        ]
	        );
	
	        $this->add_control(
		        'product_id_2',
		        [
			        'label' => esc_html__("Product 2 ID", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::TEXT
		        ]
	        );
	
	        $this->add_control(
		        'products_position',
		        [
			        'label' => esc_html__("Products position", 'stockholm-core'),
			        'type' => \Elementor\Controls_Manager::SELECT,
			        'options' => [
				        'left'    => esc_html__('Left', 'stockholm-core'),
				        'right'   => esc_html__('Right', 'stockholm-core'),
			        ],
			        'description' => esc_html__( "Choose where products will be placed related to category position.", 'stockholm-core' ),
			        'default' => 'left'
		        ]
	        );
	        
            $this->end_controls_section();
        }

        protected function render()
        {
            $params = $this->get_settings_for_display();
            
            echo stockholm_qode_get_shortcode_template_part('templates/product-categories-showcase', '_product-categories-showcase', '', $params);
        }

    }
	
	if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
		\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorProductCategoriesShowcase() );
	} else {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorProductCategoriesShowcase() );
	}
}