<?php

class StockholmCoreElementorIconText extends \Elementor\Widget_Base{
	public function get_name() {
		return 'icon_text';
	}
	
	public function get_title() {
		return esc_html__( "Icon With Text", 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-icon-with-text';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'box_type',
			[
				'label' => esc_html__( "Box type", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'normal'        => esc_html__( 'Normal', 'stockholm-core' ),
					'icon_in_a_box' => esc_html__( 'Icon in a box', 'stockholm-core' ),
				],
				'default' => 'normal'
			]
		);
		
		$this->add_control(
			'box_border',
			[
				'label' => esc_html__('Box Border','stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(false,false),
				'condition' => [
					'box_type' => 'icon_in_a_box'
				]
			]
		);
		
		$this->add_control(
			'box_border_color',
			[
				'label' => esc_html__( "Box Border Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'box_type' => 'icon_in_a_box'
				]
			]
		);
		
		$this->add_control(
			'box_background_color',
			[
				'label' => esc_html__( "Box Background Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'box_type' => 'icon_in_a_box'
				]
			]
		);
		
		$this->add_control(
			'icon_source',
			[
				'label' => esc_html__( "Icon Source", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'icon_pack' => esc_html__( 'Icon Pack', 'stockholm-core' ),
					'custom_icon' => esc_html__( 'Custom Icon', 'stockholm-core' )
				]
			]
		);
		
		stockholm_qode_icon_collections()->getElementorParamsArray($this, array('icon_source' => 'icon_pack'), '', true);
		
		$this->add_control(
			'custom_icon_image',
			[
				'label' => esc_html__( "Custom Icon", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'icon_source' => 'custom_icon'
				]
			]
		);
		
		$this->add_control(
			'icon_type',
			[
				'label' => esc_html__( "Icon Type", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'normal' => esc_html__( 'Normal', 'stockholm-core' ),
					'circle' => esc_html__( 'Circle', 'stockholm-core' ),
					'square' => esc_html__( 'Square', 'stockholm-core' ),
				],
				"description" => esc_html__( "This attribute doesn't work when Icon Position is Top With Title Over. In This case Icon Type is Normal", 'stockholm-core' ),
				'condition' => [
					'icon_pack' => array( 'font_awesome', 'font_elegant', 'linear_icons' )
				]
			]
		);
		
		$this->add_control(
			'icon_border_width',
			[
				'label' => esc_html__( "Icon Border Width (px)", 'stockholm-core' ),
				"description" => esc_html__( "Enter just number, omit pixels", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'icon_type' => array( 'circle', 'square' )
				]
			]
		);
		
		$this->add_control(
			'without_double_border_icon',
			[
				'label' => esc_html__( "Without Outer Border on Icon?", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'condition' => [
					'icon_type' => array( 'circle', 'square' )
				]
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( "Icon Size / Icon Space From Text", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'fa-lg' => esc_html__( 'Tiny', 'stockholm-core' ),
					'fa-2x' => esc_html__( 'Small', 'stockholm-core' ),
					'fa-3x' => esc_html__( 'Medium', 'stockholm-core' ),
					'fa-4x' => esc_html__( 'Large', 'stockholm-core' ),
					'fa-5x' => esc_html__( 'Very Large', 'stockholm-core' ),
				],
				"description" => esc_html__( "This attribute doesn't work when Icon Position is Top With Title Over", 'stockholm' ),
				'condition' => [
					'icon_pack' => 'font_awesome'
				]
			]
		);
		
		$this->add_control(
			'custom_icon_size',
			[
				'label' => esc_html__( "Custom Icon Size (px)", 'stockholm-core' ),
				"description" => esc_html__("Default value is 20", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'icon_pack' => array( 'font_elegant', 'linear_icons' )
				]
			]
		);
		
		$this->add_control(
			'text_left_padding',
			[
				'label' => esc_html__( "Text Left Padding (px)", 'stockholm-core' ),
				"description" => esc_html__("Default value is 86. Only when Icon Position is Left", 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'icon_pack' => array( 'font_elegant', 'linear_icons' )
				]
			]
		);
		
		$this->add_control(
			'icon_animation',
			[
				'label' => esc_html__( "Icon Animation", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'No', 'stockholm-core' ),
					'q_icon_animation' => esc_html__( 'Yes', 'stockholm-core' ),
				],
				'default' => ''
			]
		);
		
		$this->add_control(
			'icon_animation_delay',
			[
				'label' => esc_html__( "Icon Animation Delay (ms)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'icon_animation' => 'q_icon_animation'
				]
			]
		);
		
		$this->add_control(
			'icon_position',
			[
				'label' => esc_html__( "Icon/Image Position", 'stockholm-core' ),
				"description" => esc_html__( "Icon Position (only for normal box type)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'top'               => esc_html__( 'Top', 'stockholm-core' ),
					'left'              => esc_html__( 'Left', 'stockholm-core' ),
					'left_from_title'   => esc_html__( 'Left From Title', 'stockholm-core' ),
				],
				'default' => 'top',
				'condition' => [
					'box_type' => 'normal'
				]
			]
		);
		
		$this->add_control(
			'icon_margin',
			[
				'label' => esc_html__( "Icon Margin", 'stockholm-core' ),
				"description" => esc_html__( "Margin should be set in a top right bottom left format", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'icon_border_color',
			[
				'label' => esc_html__( "Icon Border Color", 'stockholm-core' ),
				"description" => esc_html__( "Only for Square and Circle type", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'icon_type' => array('square','circle')
				]
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( "Icon Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'icon_pack' => array('font_awesome', 'font_elegant', 'linear_icons')
				]
			]
		);
		
		$this->add_control(
			'icon_background_color',
			[
				'label' => esc_html__( "Icon Background Color", 'stockholm-core' ),
				"description" => esc_html__( "Icon Background Color (only for square and circle icon type)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'icon_type' => array( 'square', 'circle' )
				]
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag( false, array( 'p' => 'p' ) ),
				'default' => 'h4',
				'condition' => [
					'title!' => array( '' )
				]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( "Title Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => array( '' )
				]
			]
		);
		
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__( "Title Top Padding (px)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0',
				"description" => esc_html__( "This attribute is used for boxed type", 'stockholm-core' ),
				'condition' => [
					'box_type' => 'icon_in_a_box'
				]
			]
		);
		
		$this->add_control(
			'text',
			[
				'label' => esc_html__( "Text", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( "Text Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'link',
			[
				'label' => esc_html__( "Link", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'link_text',
			[
				'label' => esc_html__( "Link Text", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Default value is READ MORE", 'stockholm-core' ),
				'condition' => [
					'link!' => ''
				]
			]
		);
		
		$this->add_control(
			'link_color',
			[
				'label' => esc_html__( "Link Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'link_text!' => ''
				]
			]
		);
		
		$this->add_control(
			'target',
			[
				'label' => esc_html__( "Target", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_link_target_array( true ),
				'default' => '',
				'condition' => [
					'link!' => ''
				]
			]
		);
		
		$this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		
		$params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
		
		if ( !empty($params['icon_source'] && $params['icon_source'] === 'custom_icon' ) ) {
			$params['icon_pack'] = 'custom_icon';
		}
		
		if( ! empty( $params['custom_icon_image'] ) ){
			$params['custom_icon_image'] = $params['custom_icon_image']['id'];
		}
		
		$params['args']['title_tag'] = 'h4';

        if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_get_shortcode_template_part('templates/icon-with-text', '_icon-with-text', '', $params);
        }
	}

    private function get_shortcode_snippet( $params ) {
        $atts = array();

        if ( empty( $this ) || ! is_object( $this ) ) {
            return '';
        }

        if ( ! empty( $params ) ) {
            foreach ( $params as $key => $value ) {
                if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                    continue;
                }

                if( empty( $value ) || $value == '' ){
                    continue;
                }

                $atts[] = $key . '="' . esc_attr( $value ) . '"';
            }
        }

        return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
            'icon_text',
            implode( ' ', $atts )
        );
    }
	
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorIconText() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorIconText() );
}