<?php

if ( ! function_exists( 'stockholm_core_is_installed' ) ) {
	/**
	 * Function that checks if forward module installed
	 *
	 * @param $name string - module name
	 *
	 * @return bool
	 */
	function stockholm_core_is_installed( $name ) {
		
		switch ( $name ) {
			case 'theme';
				return defined( 'STOCKHOLM_QODE' );
				break;
			case 'woocommerce';
				return function_exists( 'is_woocommerce' );
				break;
			case 'visual-composer';
				return class_exists( 'WPBakeryVisualComposerAbstract' );
				break;
			case 'gutenberg-editor';
				return function_exists( 'register_block_type' );
				break;
            case 'revolution-slider';
                return class_exists('RevSliderFront');
                break;
            case 'layer-slider';
                return defined('LS_PLUGIN_VERSION');
                break;
			case 'elementor';
				return defined('ELEMENTOR_VERSION');
				break;
			case 'qi-blocks';
				return defined('QI_BLOCKS_VERSION');
				break;
			default:
				return false;
		}
	}
}

if(!function_exists('stockholm_core_get_module_template_part')) {

    function stockholm_core_get_module_template_part($template, $module, $slug = '', $params = array()) {
        $template_path = STOCKHOLM_CORE_MODULES_PATH . '/' .$module;

        return stockholm_core_return_template_part($template_path.'/'.$template, $slug, $params);

    }
}

if(!function_exists('stockholm_core_return_template_part')) {
    /**
     * Loads template part with parameters. If file with slug parameter added exists it will load that file, else it will load file without slug added.
     * Child theme friendly function
     *
     * @param string $template name of the template to load without extension
     * @param string $slug
     * @param array $params array of parameters to pass to template
     *
     * @return html
     * @see stockholm_qode_get_template_part()
     */
    function stockholm_core_return_template_part($template, $slug = '', $params = array()) {
        if(is_array($params) && count($params)) {
            extract($params);
        }
        $html          = '';
        $templates = array();

        if($template !== '') {
            if($slug !== '') {
                $templates[] = "{$template}-{$slug}.php";
            }

            $templates[] = $template.'.php';
        }

        $located = stockholm_qode_find_template_path($templates, true);

        if($located) {
            ob_start();
            include($located);
            $html = ob_get_clean();
        }

        return $html;
    }
}

if(!function_exists('stockholm_core_remove_auto_ptag')) {
    function stockholm_core_remove_auto_ptag($content, $autop = false) {
        if($autop) {
            $content = preg_replace('#^<\/p>|<p>$#', '', $content);
        }

        return do_shortcode($content);
    }
}
if(!function_exists('stockholm_core_get_required_plugins_links')) {
	/**
	 * Function that returns whether plugin should be activated or installed
	 * @return html with plugins and their state
	 *
	 * @version 0.1
	 */
	function stockholm_core_get_required_plugins_links($demo){

		//if theme is installed
		if( stockholm_core_is_installed('theme') ) {
			$plugins = array();
			$html = '';


			$demos = stockholm_core_demos_list();
			$plugins = stockholm_qode_plugins_list($demos[$demo]['required-plugins']);

			$tgmpa = $GLOBALS['tgmpa'];
			$tgmpa->config(array('menu' => 'install-required-plugins'));

			if (!empty($plugins)) {
				$required_demo_plugins = array();

				$html .= "<p class='qode-demo-plugins-intall-main-title'>" . esc_html__('Following plugins should be installed and activated before demo import:', 'stockholm-core') . "</p>";
				foreach ($plugins as $key => $value) {

					$tgmpa->register(array('slug' => $key, 'name' => $value));

					$is_plugin_active = $tgmpa->is_plugin_active($key);
					$is_plugin_installed = $tgmpa->is_plugin_installed($key);

					if (!$is_plugin_active) {
						$status = $is_plugin_installed ? 'activate' : 'install';
						$link_text = $is_plugin_installed ? esc_html__('Activate', 'stockholm-core') : esc_html__('Install', 'stockholm-core');

						$status = "<a class='qode-demo-plugin-install-link' href='" . $tgmpa->get_tgmpa_status_url($status) . "'>" . $link_text . "</a>";
					} else {
						$status = "<span class='qode-demo-plugin-intalled'>" . esc_html__('Activated', 'stockholm-core') . "</span>";
					}

					$html .= "<p>" . $value . " - " . $status . "<span class='spinner'></span></p>";

					array_push($required_demo_plugins, $key);
				}
				$html .= "<span style='visibility:hidden;' data-required-demo-plugins='" . json_encode($required_demo_plugins) . "' class='qode-required-demo-plugins-list'></span>";
			}

			return $html;
		}
	}

}

if ( ! function_exists( 'stockholm_core_ajax_status' ) ) {
	/**
	 * Function that return status from ajax functions
	 */
	function stockholm_core_ajax_status( $status, $message, $data = null ) {
		$response = array(
			'status'  => $status,
			'message' => $message,
			'data'    => $data
		);

		$output   = json_encode( $response );

		exit( $output );
	}
}

if( ! function_exists( 'stockholm_core_is_theme_registered' ) ) {
	function stockholm_core_is_theme_registered() {
		return class_exists('StockholmCoreDashboard') ? StockholmCoreDashboard::get_instance()->is_theme_registered() : true;
	}
}
