<?php

namespace Stockholm\Shortcodes\HorizontalLayout;

use Stockholm\Shortcodes\Lib\ShortcodeInterface;

class HorizontalLayout implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'qode_horizontal_layout';

		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map( array(
					'name'     => esc_html__( 'Horizontal Layout', 'stockholm-core' ),
					'base'     => $this->getBase(),
					'category' => esc_html__( 'by SELECT', 'stockholm-core' ),
					'icon'     => 'icon-wpb-horizontal-layout extended-custom-icon-qode',
					'params'   => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'intro_title',
							'heading'     => esc_html__( 'Intro Title', 'stockholm-core')
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'intro_button_link',
							'heading'     => esc_html__( 'Intro Button Link', 'stockholm-core'),
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'intro_button_text',
							'heading'     => esc_html__( 'Intro Button Text', 'stockholm-core'),
							'dependency'  => array('element' => 'intro_button_link', 'not_empty' => true)
						),
						array(
							'type'        => 'colorpicker',
							'param_name'  => 'content_background_color',
							'heading'     => esc_html__( 'Content Background Color', 'stockholm-core')
						),
						array(
							'type' => 'param_group',
							'heading' => esc_html__( 'Items', 'stockholm-core' ),
							'param_name' => 'items',
							'value' => '',
							'params' => array(
								array(
									'type' => 'attach_image',
									'heading' => esc_html__( 'Image', 'stockholm-core'),
									'param_name' => 'image',
								),
								array(
									'type' => 'attach_image',
									'heading' => esc_html__( 'Small Image 1', 'stockholm-core'),
									'param_name' => 'image_small_1',
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Small Image 1 Link', 'stockholm-core'),
									'param_name' => 'image_small_1_link',
								),
								array(
									'type' => 'attach_image',
									'heading' => esc_html__( 'Small Image 2', 'stockholm-core'),
									'param_name' => 'image_small_2',
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Small Image 2 Link', 'stockholm-core'),
									'param_name' => 'image_small_2_link',
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Title', 'stockholm-core'),
									'param_name' => 'title',
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Link', 'stockholm-core'),
									'param_name' => 'link',
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Target', 'stockholm-core'),
									'param_name' => 'target',
									'value' => array(
										esc_html__( 'Blank', 'stockholm-core') => '_blank',
										esc_html__( 'Self', 'stockholm-core') => '_self',
									)
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Text', 'stockholm-core'),
									'param_name' => 'text',
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Text Link', 'stockholm-core'),
									'param_name' => 'text_link',
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Text Target', 'stockholm-core'),
									'param_name' => 'text_target',
									'value' => array(
										esc_html__( 'Blank', 'stockholm-core') => '_blank',
										esc_html__( 'Self', 'stockholm-core') => '_self',
									)
								),
							)
						),
					)
				)
			);
		}
	}

	public function render( $atts, $content = null ) {
		$args   = array(
			'intro_title'   => '',
			'intro_button_link'   => '',
			'intro_button_text'   => '',
			'content_background_color'   => '',
			'items' => ''
		);
		$params = shortcode_atts( $args, $atts );

		/***
		 * @params query_results
		 * @params holder_data
		 * @params holder_classes
		 * @params holder_inner_classes
		 */

		$params['items'] = json_decode(urldecode($params['items']), true);
		var_dump($params['items']);
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['item_classes']   = $this->getItemClasses( $params );
		$params['this_object']    = $this;
		$params['animation_data'] = $this->getAnimationData( $params );
		$params['is_elementor'] = false;

		return stockholm_qode_get_shortcode_template_part( 'templates/horizontal-layout', 'horizontal-layout', '', $params );
	}

	private function getAnimationData( $atts ) {
		$animation_data = array();

		$animation_data[] = ( ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes') ? 'data-splitting' : '';

		return implode( ' ', $animation_data );
	}

	private function getHolderClasses( $atts ) {
		$holder_classes[] = 'qodef-horizontal-layout';
		$holder_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--has-appear qodef--splitting' : '';

		return implode( ' ', $holder_classes );
	}

	private function getItemClasses( $atts ) {
		$item_classes = array();

		$item_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--has-appear qodef--has-horizontal-appear qodef--splitting' : '';

		return implode( ' ', $item_classes  );
	}
}
