<?php
/* Product list shortcode */
if (!function_exists('qode_product_list')) {
	function qode_product_list($atts, $content = null) {
		$args = array(
			'type' => 'standard',
			'columns' => '4',
			'items_number' => '-1',
			'order_by' => 'date',
			'sort_order' => 'desc',
			'taxonomy_to_display' => 'category',
			'taxonomy_values' => '',
			'display_categories' => 'yes'
		);
		
		$params = shortcode_atts($args, $atts);
		$params['content'] = $content;
		$params['args'] = $args;
		if($params['type'] == 'standard') {
			do_action('stockholm_qode_action_pl_standard_initial_setup', $params);
		}
		else if($params['type'] == 'simple') {
			do_action('stockholm_qode_action_pl_simple_initial_setup');
		}
		
		extract($params);
		
		return stockholm_qode_get_shortcode_template_part('templates/product-list', '_product-list', '', $params);
		
	}
	add_shortcode('qode_product_list', 'qode_product_list');
}