<?php

class StockholmCoreElementorPricingList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_pricing_list';
    }

    public function get_title() {
        return esc_html__( 'Pricing List', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-pricing-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
	
	    $repeater->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__( 'Title Tag', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag(false),
			    'default' => 'h4'
		    ]
	    );

        
        $repeater->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        
        $repeater->add_control(
            'price',
            [
                'label' => esc_html__( 'Price', 'stockholm-core'),
                "description" => esc_html__( 'You can append any unit that you want', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '0'
            ]
        );
	
	    $repeater->add_control(
		    'enable_highlighted_item',
		    [
			    'label' => esc_html__( 'Highlighted Item', 'stockholm-core'),
			    "description" => esc_html__( 'Set as highlighted item?', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SWITCHER
		    ]
	    );
	
	    $repeater->add_control(
		    'highlighted_text',
		    [
			    'label' => esc_html__( 'Highlighted Text', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
			        'enable_highlighted_item' => 'yes'
			    ]
		    ]
	    );
	
	    $repeater->add_control(
		    'margin_bottom_item',
		    [
			    'label' => esc_html__( 'Item Margin Bottom (px)', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
	    
        $this->add_control(
            'pricing_list_items',
            [
                'label' => esc_html__( 'Pricing List Items', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Pricing List Item'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        ?>

        <div class="qode-pricing-list">
            <ul class="qode-pricing-list-holder">
                <?php

                    foreach( $params['pricing_list_items'] as $pricing_list_item ){
                        echo stockholm_qode_get_shortcode_template_part('templates/pricing-list-item', '_pricing-list', '', $pricing_list_item);
                    }

                ?>
            </ul> <!-- close ul.qode_pricing_list_holder -->
        </div> <!-- close div.qode_pricing_list -->

        <?php

    }
}


if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorPricingList() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPricingList() );
}