<?php

class StockholmCoreElementorImageWithText extends \Elementor\Widget_Base{
	public function get_name() {
		return 'image_with_text';
	}
	
	public function get_title() {
		return esc_html__( "Image With Text", 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-image-with-text';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'image',
			[
				'label' => esc_html__( "Image", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( "Title Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag( true ),
				'default' => 'h5'
			]
		);
		
		$this->add_control(
			'content',
			[
				'label' => esc_html__( "Content", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => "<p>".esc_html__( 'This is custom text content for shortcode element', 'stockholm-core' )."</p>"
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		
		if( ! empty($params['image']) ){
			$params['image'] = $params['image']['id'];
		}
		
		echo stockholm_qode_get_shortcode_template_part('templates/image-with-text', '_image-with-text', '', $params);
	}
	
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorImageWithText() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorImageWithText() );
}