<?php

class StockholmCoreElementorIcon extends \Elementor\Widget_Base{
    public function get_name() {
        return 'icons';
    }

    public function get_title() {
        return esc_html__( "Icon", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-icon';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);

        $this->add_control(
            'fa_size',
            [
                'label' => esc_html__( "Size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'fa-lg' => esc_html__( 'Tiny', 'stockholm-core' ),
                    'fa-2x' => esc_html__( 'Small', 'stockholm-core' ),
                    'fa-3x' => esc_html__( 'Medium', 'stockholm-core' ),
                    'fa-4x' => esc_html__( 'Large', 'stockholm-core' ),
                    'fa-5x' => esc_html__( 'Very Large', 'stockholm-core' ),
                ],
                'default' => 'fa-lg',
                'condition' => [
	                'icon_pack' => 'font_awesome'
                ]
            ]
        );
	
	    $this->add_control(
		    'custom_size',
		    [
			    'label' => esc_html__( "Custom Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );

        $this->add_control(
            'type',
            [
                'label' => esc_html__( "Type", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'normal' => esc_html__( 'Normal', 'stockholm-core' ),
                    'circle' => esc_html__( 'Circle', 'stockholm-core' ),
                    'square' => esc_html__( 'Square', 'stockholm-core' )
                ],
                'default' => 'normal'
            ]
        );
        
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( "Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => esc_html__( "Icon Hover Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'position',
		    [
			    'label' => esc_html__( "Position", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''          => esc_html__( 'Normal', 'stockholm-core' ),
				    'left'      => esc_html__( 'Left', 'stockholm-core' ),
				    'center'    => esc_html__( 'Center', 'stockholm-core' ),
				    'right'     => esc_html__( 'Right', 'stockholm-core' ),
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'border_color',
		    [
			    'label' => esc_html__( "Border Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'type' => array("circle", "square")
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'border_hover_color',
		    [
			    'label' => esc_html__( "Border Hover Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'type' => array("circle", "square")
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'border_width',
		    [
			    'label' => esc_html__( "Border Width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'description' => esc_html__( "Enter just number. Omit pixels", 'stockholm-core' ),
			    'condition' => [
				    'type' => array("circle", "square")
			    ]
		    ]
	    );
	    
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__( "Border Radius (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__( "Enter just number. Omit pixels", 'stockholm-core' ),
                'condition' => [
	                'type' => array("circle", "square")
                ]
            ]
        );
        
        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( "Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'type' => array("circle", "square")
                ]
            ]
        );

        $this->add_control(
            'background_hover_color',
            [
                'label' => esc_html__( "Background Hover Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'type' => array("circle", "square")
                ]
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__( "Margin", 'stockholm-core' ),
                "description" => esc_html__( "Margin (top right bottom left)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'icon_animation',
            [
                'label' => esc_html__( "Icon Animation", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'No', 'stockholm-core' ),
                    'q_icon_animation' => esc_html__( 'Yes', 'stockholm-core' ),
                ],
                'default' => ''
            ]
        );

        $this->add_control(
            'icon_animation_delay',
            [
                'label' => esc_html__( "Icon Animation Delay (ms)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'icon_animation' => 'q_icon_animation'
                ]
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( "Link", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        
        $this->add_control(
            'target',
            [
                'label' => esc_html__( "Target", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_link_target_array(),
                'default' => '_self'
            ]
        );

        $this->end_controls_section();

		// Add predefined developer tab content for each shortcode element
		$this->start_controls_section(
			'developer_tools',
			[
				'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'shortcode_snippet',
			[
				'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => stockholm_qode_get_yes_no_select_array()
			]
		);

		$this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );

		if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
			echo $this->get_shortcode_snippet( $params );
		} else{
			echo stockholm_qode_get_shortcode_template_part('templates/icon', '_icon', '', $params);
		}
    }

	private function get_shortcode_snippet( $params ) {
		$atts = array();

		if ( empty( $this ) || ! is_object( $this ) ) {
			return '';
		}

		if ( ! empty( $params ) ) {
			foreach ( $params as $key => $value ) {
				if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
					continue;
				}

				if( empty( $value ) || $value == '' ){
					continue;
				}

				$atts[] = $key . '="' . esc_attr( $value ) . '"';
			}
		}

		return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
			'icons',
			implode( ' ', $atts )
		);
	}

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorIcon() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorIcon() );
}