<?php

class StockholmCoreElementorIconListItem extends \Elementor\Widget_Base{
    public function get_name() {
        return 'icon_list_item';
    }

    public function get_title() {
        return esc_html__( "Icon List Item", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-icon-list-item';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);

        $this->add_control(
            'icon_type',
            [
                'label' => esc_html__( "Icon Type", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'normal_icon_list' => esc_html__( 'Normal', 'stockholm-core' ),
                    'small_icon_list'  => esc_html__( 'Small', 'stockholm-core' ),
                ],
                'default' => 'normal_icon_list'
            ]
        );
        
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( "Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'border_type',
		    [
			    'label' => esc_html__( "Border Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'circle'  => esc_html__( 'Circle', 'stockholm-core' ),
				    'square'  => esc_html__( 'Square', 'stockholm-core' ),
			    ],
			    'default' => 'circle'
		    ]
	    );
        
        $this->add_control(
            'border_color',
            [
                'label' => esc_html__( "Border Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'title_size',
            [
                'label' => esc_html__( "Title size (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

	    $this->add_control(
		    'item_link',
		    [
			    'label' => esc_html__( "Item Link", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );

	    $this->add_control(
		    'item_link_target',
		    [
			    'label' => esc_html__( "Item Link Target", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_link_target_array(),
			    'default' => '_self',
			    'condition' => [
				    'item_link!' => ''
			    ]
		    ]
	    );

        $this->end_controls_section();

	    // Add predefined developer tab content for each shortcode element
	    $this->start_controls_section(
		    'developer_tools',
		    [
			    'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
			    'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		    ]
	    );

	    $this->add_control(
		    'shortcode_snippet',
		    [
			    'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
			    'type'    => \Elementor\Controls_Manager::SELECT,
			    'default' => 'no',
			    'options' => stockholm_qode_get_yes_no_select_array()
		    ]
	    );

	    $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
	    if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
		    echo $this->get_shortcode_snippet( $params );
	    } else {
		    echo stockholm_qode_get_shortcode_template_part( 'templates/icon-list-item', '_icon-list-item', '', $params );
	    }
    }

	private function get_shortcode_snippet( $params ) {
		$atts = array();

		if ( empty( $this ) || ! is_object( $this ) ) {
			return '';
		}

		if ( ! empty( $params ) ) {
			foreach ( $params as $key => $value ) {
				if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
					continue;
				}

				if( empty( $value ) || $value == '' ){
					continue;
				}

				$atts[] = $key . '="' . esc_attr( $value ) . '"';
			}
		}

		return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
			'icon_list_item',
			implode( ' ', $atts )
		);
	}

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorIconListItem() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorIconListItem() );
}