(function($) {
    'use strict';

    var elementorFullscreenSections = {};
    qode.modules.elementorFullscreenSections = elementorFullscreenSections;

    elementorFullscreenSections.qodeInitElementorFullscreenSections = qodeInitElementorFullscreenSections;


    elementorFullscreenSections.qodeOnWindowLoad = qodeOnWindowLoad;

    $(window).on('load', qodeOnWindowLoad());

    /*
     ** All functions to be called on $(window).load() should be in this function
     */
    function qodeOnWindowLoad() {
        qodeInitElementorFullscreenSections();
    }

    function qodeInitElementorFullscreenSections(){
        $j(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_fullscreen_sections.default', function() {
                var isElementorEditMode = false;

                if( typeof elementorFrontend !== 'undefined' ){
                    isElementorEditMode = Boolean(elementorFrontend.isEditMode());
                };

                if( isElementorEditMode ){
                    //If elementor edit mode is enabled destroy and than rebuild whole FS Template
                    if( typeof $j.fn.fullpage.destroy == 'function' ){
                        $j.fn.fullpage.destroy('all');
                    }
                    initFullScreenTemplate();
                }
            } );
        });
    }

})(jQuery);
