<?php

class StockholmCoreElementorBlockquote extends \Elementor\Widget_Base{
    public function get_name() {
        return 'blockquote';
    }

    public function get_title() {
        return esc_html__( 'Blockquote', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-blockquote';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Blockquote text', 'stockholm-core' ),
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( "Text Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );
	
	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__( "Text Tag", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( false ),
			    'default' => 'h5'
		    ]
	    );

        $this->add_control(
            'width',
            [
                'label' => esc_html__( "Width", 'stockholm-core' ),
                'description' => esc_html__( "Width (%)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'line_height',
            [
                'label' => esc_html__( "Line Height", 'stockholm-core' ),
                'description' => esc_html__( "Line Height (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( "Background Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => esc_html__( "Border Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'show_quote_icon',
            [
                'label' => esc_html__( "Show Quote Icon", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, true),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'quote_icon_color',
            [
                'label' => esc_html__( "Quote Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'show_quote_icon' => 'yes'
                ]
            ]
        );
	
	    $this->add_control(
		    'quote_icon_size',
		    [
			    'label' => esc_html__( "Quote Icon Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    echo stockholm_qode_get_shortcode_template_part('templates/blockquote', '_blockquote', '', $params);
    }

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorBlockquote() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorBlockquote() );
}