<?php
if ( ! function_exists( 'stockholm_core_add_import_sub_page_to_list' ) ) {
	function stockholm_core_add_import_sub_page_to_list( $sub_pages ) {
		$sub_pages[] = 'StockholmCoreImportPage';
		return $sub_pages;
	}
	
	add_filter( 'stockholm_core_filter_add_welcome_sub_page', 'stockholm_core_add_import_sub_page_to_list', 11 );
}

if ( class_exists( 'StockholmCoreSubPage' ) ) {
	class StockholmCoreImportPage extends StockholmCoreSubPage {
		
		public function __construct() {
			parent::__construct();
		}
		
		public function add_sub_page() {
			$this->set_base( 'import' );
			$this->set_title( esc_html__('Import', 'stockholm-core'));
			$this->set_atts( $this->set_atributtes());
		}

		public function set_atributtes(){
			$params = array();

			$iparams = StockholmCoreDashboard::get_instance()->get_import_params();
			if(is_array($iparams) && isset($iparams['submit'])) {
				$params['submit'] = $iparams['submit'];
			}

			$params['demos_list'] = stockholm_core_demos_list();
			$params['filter_categories'] = $this->get_categories();

			return $params;
		}

		public function get_categories() {
			return array(

				'architecture-property' => esc_html__('Architecture & Property', 'stockholm-core'),
				'art'                   => esc_html__('Art', 'stockholm-core'),
				'business'              => esc_html__('Business', 'stockholm-core'),
				'blog-magazine'         => esc_html__('Blog & Magazine', 'stockholm-core'),
				'creative-agency'       => esc_html__('Creative Agency', 'stockholm-core'),
				'fashion'               => esc_html__('Fashion', 'stockholm-core'),
				'food-restaurant'       => esc_html__('Food & Restaurant', 'stockholm-core'),
				'health-beauty'         => esc_html__('Health & Beauty', 'stockholm-core'),
				'landing-page'          => esc_html__('Landing Page', 'stockholm-core'),
				'online-store'          => esc_html__('Online Store', 'stockholm-core'),
				'other'                 => esc_html__('Other', 'stockholm-core'),
				'personal-presentation' => esc_html__('Personal Presentation', 'stockholm-core'),
				'photography'           => esc_html__('Photography', 'stockholm-core'),
				'portfolio'             => esc_html__('Portfolio', 'stockholm-core'),
				'technology'            => esc_html__('Technology', 'stockholm-core'),
				'wedding'               => esc_html__('Wedding', 'stockholm-core'),
			);
		}

	}
}